<?php
/**
 * SISTEMA BLINDADO - REPRODUÇÃO 4K 60FPS & CONTROLE PARENTAL
 * OTIMIZAÇÃO: ENGINE 4K H265 & EPG REAL-TIME ATIVADO (CENTRALIZADO)
 */
ob_start(); 
ini_set('memory_limit', '512M'); 
error_reporting(0);             

include "session.php";

// Handler para o EPG em Tempo Real (AJAX) - Motor Ativado
if (isset($_GET['action']) && $_GET['action'] === 'ajax_epg' && isset($_GET['stream_id'])) {
    include "config.php";
    $id = $_GET['stream_id'];
    
    // Define fuso horário para o AJAX
    if (isset($_COOKIE['user_timezone'])) {
        date_default_timezone_set($_COOKIE['user_timezone']);
    }

    $url = $get_dns . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password) . "&action=get_short_epg&stream_id=" . urlencode($id);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $res = curl_exec($ch);
    $data = json_decode($res, true);
    $listings = $data['epg_listings'] ?? [];
    
    if (!empty($listings)) {
        foreach ($listings as $p) {
            $title = base64_encode(base64_decode($p['title'], true)) === $p['title'] ? base64_decode($p['title']) : $p['title'];
            
            // Renderiza o título centralizado através da estrutura CSS
            echo '<div class="epg-item">
                    <span>'.htmlspecialchars($title).'</span>
                  </div>';
        }
    } else {
        echo '<p style="padding:20px; opacity:0.3; text-align:center">Sem informações de guia.</p>';
    }
    exit;
}

if (!(isset($_GET['category_id']) && !isset($_GET['slug']))) {
    include "header.php";
}
include "config.php";

$parental_password = "1234"; 

function getXtreamData($endpoint, $params = []) {
    global $get_dns, $username, $password;
    $url = $get_dns . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password) . "&action=" . urlencode($endpoint);
    if (!empty($params)) $url .= '&' . http_build_query($params);
    
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_USERAGENT => 'Mozilla/5.0 VLC_Hybrid_Core/7.0',
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_TIMEOUT => 25,
        CURLOPT_CONNECTTIMEOUT => 12,
        CURLOPT_ENCODING => "gzip" 
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200 || !$response) return [];
    $decoded = json_decode($response, true) ?? [];
    unset($response); 
    return $decoded;
}

function isAdultCategory($name) {
    $adult_keywords = ['adultos', 'xxx', 'porn', 'hot', 'sexy', 'erotico', '18+', 'for adult'];
    $name = strtolower($name);
    foreach ($adult_keywords as $key) {
        if (strpos($name, $key) !== false) return true;
    }
    return false;
}

function decodeBase64IfNeeded($data) {
    if (base64_encode(base64_decode($data, true)) === $data) return base64_decode($data);
    return $data;
}

if (isset($_COOKIE['user_timezone'])) {
    $valid_timezones = timezone_identifiers_list();
    $user_timezone = $_COOKIE['user_timezone'];
    date_default_timezone_set(in_array($user_timezone, $valid_timezones) ? $user_timezone : 'UTC');
} else {
    date_default_timezone_set('UTC');
    echo '<script>
        var tz = Intl.DateTimeFormat().resolvedOptions().timeZone;
        document.cookie = "user_timezone=" + tz + "; path=/; max-age=31536000";
        location.reload();
    </script>';
    exit();
}

$id = $_GET["id"] ?? null;
$slug = $_GET["slug"] ?? null;
$selectedCategoryId = $_GET['category_id'] ?? null;

if ($slug == "live" && $id !== null) {
    $video_url = $get_dns . "/live/" . urlencode($username) . "/" . urlencode($password) . "/" . urlencode($id) . ".m3u8";
    $epg_info = getXtreamData('get_short_epg', ['stream_id' => $id, 'limit' => 15]);
    $epg_data = $epg_info['epg_listings'] ?? [];
    unset($epg_info); 
}

if (isset($_GET['category_id']) && !isset($_GET['slug'])) {
    $channels = getXtreamData('get_live_streams', ['category_id' => $_GET['category_id']]);
    if (empty($channels)) { echo "<p class='empty-msg'>Nenhum canal nesta categoria.</p>"; exit; }
    
    foreach ($channels as $channel) {
        $sid = htmlspecialchars($channel["stream_id"]);
        $title = htmlspecialchars($channel["name"]);
        $img = htmlspecialchars($channel["stream_icon"]);
        echo "<div class='channel-item' onclick='playChannel({$sid})'>
                <img src='{$img}' onerror=\"this.src='img/sTREAMING (3) (1).png';\" loading='lazy'/>
                <div class='channel-meta'>
                    <p class='chan-name'>{$title}</p>
                    <span class='stream-tag'>Live Stream</span>
                </div>
              </div>";
    }
    exit();
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SISTEMA BLINDADO IPTV - 4K 60FPS</title>
    <link rel="stylesheet" href="https://cdn.plyr.io/3.7.8/plyr.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
    <style>
        :root { 
            --main-red: #ff003c; 
            --cyan: #00f2ff; 
            --bg: #050507; 
            --card-bg: rgba(255, 255, 255, 0.04); 
            --plyr-color-main: #ff003c;
        }
        body { margin: 0; background: var(--bg); color: #fff; font-family: 'Inter', sans-serif; overflow-x: hidden; }
        .main-container { display: grid; grid-template-columns: 280px 1fr 320px; height: 100vh; gap: 15px; padding: 15px; box-sizing: border-box; }
        .glass-box { background: var(--card-bg); border-radius: 20px; border: 1px solid rgba(255,255,255,0.1); overflow-y: auto; backdrop-filter: blur(10px); }

        @media (max-width: 1024px) {
            .main-container { grid-template-columns: 1fr; grid-template-rows: auto auto auto; height: auto; }
            .category-panel { order: 2; height: 300px; }
            .player-panel { order: 1; position: sticky; top: 10px; z-index: 100; }
            .channel-panel { order: 3; height: 500px; }
        }

        .category-item { padding: 12px 15px; margin: 5px 10px; border-radius: 10px; cursor: pointer; transition: 0.3s; font-size: 0.9rem; border-left: 3px solid transparent; }
        .category-item:hover { background: rgba(255,0,60,0.15); border-left-color: var(--main-red); }
        .channel-item { display: flex; align-items: center; gap: 12px; padding: 10px; margin: 5px 10px; background: rgba(255,255,255,0.02); border-radius: 12px; cursor: pointer; transition: 0.2s; }
        .channel-item:hover { background: rgba(0, 242, 255, 0.1); transform: scale(1.02); }
        .channel-item img { width: 50px; height: 50px; border-radius: 8px; object-fit: contain; background: #000; }
        
        .video-box { 
            width: 100%; 
            aspect-ratio: 16/9; 
            background: #000; 
            border-radius: 20px; 
            overflow: hidden; 
            box-shadow: 0 0 40px rgba(0,0,0,0.9), 0 0 20px rgba(255,0,60,0.1);
            position: relative;
            border: 1px solid rgba(255,255,255,0.05);
        }
        
        .plyr--full-ui.plyr--video .plyr__control--overlaid { background: var(--main-red); }
        .plyr--video .plyr__controls { background: linear-gradient(rgba(0,0,0,0), rgba(0,0,0,0.85)) !important; border-radius: 0 0 20px 20px; }
        .plyr--video .plyr__control:hover { background: var(--main-red) !important; color: #fff !important; }

        .placeholder-player {
            height:100%; display:flex; flex-direction:column; align-items:center; justify-content:center; text-align:center;
            background: radial-gradient(circle, rgba(255,0,60,0.05) 0%, rgba(5,5,7,1) 80%);
        }
        .placeholder-player i { animation: pulseIcon 2s infinite ease-in-out; }

        @keyframes pulseIcon {
            0% { transform: scale(1); opacity: 0.5; }
            50% { transform: scale(1.1); opacity: 0.8; filter: drop-shadow(0 0 15px var(--main-red)); }
            100% { transform: scale(1); opacity: 0.5; }
        }

        h3 { font-size: 0.8rem; text-transform: uppercase; color: var(--cyan); padding: 15px; margin: 0; border-bottom: 1px solid rgba(255,255,255,0.05); }
        
        /* AJUSTE PARA CENTRALIZAR O TEXTO DO EPG */
        .epg-item { 
            display: flex; 
            justify-content: center; /* Centraliza horizontalmente */
            align-items: center; 
            text-align: center;      /* Garante que o texto multi-linha também centralize */
            padding: 12px 20px; 
            border-bottom: 1px solid rgba(255,255,255,0.05); 
            font-size: 0.85rem; 
            transition: all 0.3s; 
        }

        .time-tag { color: var(--main-red); font-weight: bold; background: rgba(255,0,60,0.1); padding: 2px 8px; border-radius: 4px; }
        
        ::-webkit-scrollbar { width: 4px; }
        ::-webkit-scrollbar-thumb { background: rgba(255,255,255,0.2); border-radius: 10px; }
    </style>
</head>
<body>

<div class="main-container">
    <aside class="glass-box category-panel">
        <h3><i class="fa fa-list"></i> Categorias</h3>
        <?php
        $cats = getXtreamData('get_live_categories');
        foreach ($cats as $cat) {
            $is_adult = isAdultCategory($cat['category_name']) ? 'true' : 'false';
            echo "<div class='category-item' onclick='loadChannels(".htmlspecialchars($cat['category_id']).", {$is_adult})'>".htmlspecialchars($cat['category_name'])."</div>";
        }
        unset($cats);
        ?>
    </aside>

    <main class="player-panel">
        <div class="video-box">
            <?php if ($slug == "live"): ?>
                <video id="player" playsinline controls crossorigin></video>
            <?php else: ?>
                <div class="placeholder-player">
                    <i class="fa fa-tv fa-4x" style="color:var(--main-red); margin-bottom:15px"></i>
                    <p style="opacity:0.7; letter-spacing:3px; font-weight:bold; font-size: 0.7rem;">SISTEMA BLINDADO IPTV<br><span style="color:var(--cyan)">AGUARDANDO CANAL</span></p>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="glass-box" style="margin-top:15px; flex:1">
            <h3><i class="fa fa-clock"></i> Guia de Programação (EPG) <span id="epg-loader" style="display:none; float:right"><i class="fa fa-sync fa-spin"></i></span></h3>
            <div id="epg-list">
                <?php if (!empty($epg_data)): foreach ($epg_data as $p): ?>
                <div class="epg-item">
                    <span><?php echo htmlspecialchars(decodeBase64IfNeeded($p['title'])); ?></span>
                </div>
                <?php endforeach; else: ?>
                    <p style="padding:20px; opacity:0.3; text-align:center">Sem informações de guia.</p>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <aside class="glass-box channel-panel">
        <h3><i class="fa fa-play-circle"></i> Canais</h3>
        <div id="channel-list">
            <?php if ($selectedCategoryId): 
                $chans = getXtreamData('get_live_streams', ['category_id' => $selectedCategoryId]);
                foreach($chans as $c): ?>
                <div class="channel-item" onclick="playChannel(<?php echo $c['stream_id']; ?>)">
                    <img src="<?php echo $c['stream_icon']; ?>" onerror="this.src='img/sTREAMING (3) (1).png'">
                    <div class="channel-meta">
                        <p class="chan-name"><?php echo htmlspecialchars($c['name']); ?></p>
                        <span class="stream-tag">LIVE</span>
                    </div>
                </div>
            <?php endforeach; unset($chans); endif; ?>
        </div>
    </aside>
</div>

<script src="https://cdn.plyr.io/3.7.8/plyr.js"></script>
<script src="https://cdn.jsdelivr.net/npm/hls.js@latest"></script>

<script>
    let currentCat = <?php echo json_encode($selectedCategoryId); ?>;
    const streamId = <?php echo json_encode($id); ?>;
    const parentalPassword = "<?= $parental_password ?>";

    function loadChannels(id, isAdult) {
        if (isAdult) {
            const pass = prompt("Conteúdo Adulto. Digite a senha parental:");
            if (pass !== parentalPassword) {
                alert("Senha incorreta!");
                return;
            }
        }
        currentCat = id;
        const list = document.getElementById('channel-list');
        list.innerHTML = '<div style="text-align:center; padding:50px;"><i class="fa fa-spinner fa-spin fa-2x"></i></div>';
        fetch('?category_id=' + id)
            .then(res => res.text())
            .then(html => { list.innerHTML = html; });
    }

    function playChannel(sid) {
        window.location = 'tvguide.php?id=' + sid + '&slug=live&category_id=' + currentCat;
    }

    function refreshEPG() {
        if (!streamId) return;
        document.getElementById('epg-loader').style.display = 'inline';
        fetch('?action=ajax_epg&stream_id=' + streamId)
            .then(res => res.text())
            .then(html => {
                document.getElementById('epg-list').innerHTML = html;
                document.getElementById('epg-loader').style.display = 'none';
            })
            .catch(() => {
                document.getElementById('epg-loader').style.display = 'none';
            });
    }

    document.addEventListener('DOMContentLoaded', () => {
        const video = document.querySelector('#player');
        if(!video) return;

        setInterval(refreshEPG, 60000);

        const source = "<?php echo $video_url ?? ''; ?>";
        const player = new Plyr(video, {
            ratio: '16:9',
            controls: ['play-large', 'play', 'mute', 'volume', 'settings', 'fullscreen'],
            settings: ['quality', 'speed'],
            quality: { default: 2160, options: [2160, 1080, 720, 480] }
        });

        if (Hls.isSupported()) {
            const hls = new Hls({
                maxBufferLength: 30,
                maxMaxBufferLength: 60,
                maxBufferSize: 128 * 1024 * 1024,
                enableWorker: true,
                lowLatencyMode: true,
                backBufferLength: 90,
                abrBandWidthFactor: 0.95,
                abrBandWidthUpFactor: 0.7
            });
            hls.loadSource(source);
            hls.attachMedia(video);
            window.hls = hls;

            hls.on(Hls.Events.MANIFEST_PARSED, function() {
                video.play();
            });
        } else if (video.canPlayType('application/vnd.apple.mpegurl')) {
            video.src = source;
        }
    });
</script>
</body>
</html>
<?php ob_end_flush(); ?>